//pragma Singleton
import QtQuick 2.0
import QtQuick.Window 2.0

// https://developer.apple.com/macos/human-interface-guidelines/visual-design/color/

QtObject {
    property QtObject icon: QtObject {
        // theme will simply replace the color values in the svg
        // [0]: set in svg
        // [1]: theme replacement
        property var line1:     [ "161616", "16161d" ]
        property var line2:     [ "3e3e3e", "d5d5d5" ]
        property var line3:     [ "444444", "444444" ]
        property var line4:     [ "6f6f6f", "6f6f6f" ]
        property var line5:     [ "fcfcfc", "f9f9f9" ]
        property var fill1:     [ "202020", "202020" ]
        property var stand1:    [ "3e3e3f", "ffffff" ]  // monitor stand
        property var stand2:    [ "3e3e40", "747474" ]  // monitor stand 2
        property var fill3:     [ "555555", "555555" ]
        property var fill4:     [ "656565", "656565" ]
        property var fill5:     [ "9c9c9c", "9c9c9c" ]
        property var fill6:     [ "dddddd", "cccccc" ]
        property var fill7:     [ "fbfbfb", "fbfbfb" ]
        property var monitor1:  [ "add0ff", "b1dfff" ]
        property var monitor2:  [ "97c6ff", "88aadd" ]
        
    }

    property QtObject iconHighlight: QtObject {
        // theme will simply replace the color values in the svg
        // [0]: set in svg
        // [1]: theme replacement
        property var line1:     [ "161616", "16161d" ]
        property var line2:     [ "3e3e3e", "0077fa" ]
        property var line3:     [ "6f6f6f", "9c9ca4" ]
        property var line4:     [ "fcfcfc", "f9f9f9" ]
        property var fill1:     [ "202020", "202020" ]
        property var fill2:     [ "3d3d3d", "3d3d3d" ]
        property var fill3:     [ "555555", "0077fa" ]
        property var fill4:     [ "656565", "3398ff" ]
        property var fill5:     [ "9c9c9c", "9c9c9c" ]
        property var fill6:     [ "dddddd", "cccccc" ]
        property var fill7:     [ "fbfbfb", "fbfbfb" ]
    }

    property real scaleFactor: 1
    property color background:            "#535353"   // The background.
    property color foreground:            "#d5d6d9"   // The foreground.

    property color background2:           "#363636"   // The background2.
    property color foreground2:           "#d4d8d0"   // The foreground2.

    property color frameBorder:           "#404040"

    property color controlDown2:          "#d0d0d0"   // The surface of a control when pressed down.
    property color controlHovered2:       "#a3a3a3"   // The surface of a control when hovered.

    property color control:               "#949494"   // The surface of a control.

    property color controlText:           "#333333"   // The text of controls
    property color controlHighlight:      "#949494"   // The inner, duller color of a control’s highlight.
    property color controlLightHighlight: "#a2a2a2"   // The outer, brighter color of a control’s highlight.
    property color controlShadow:         "#545454"   // The inner, lighter portion of a control’s shadow.
    property color controlDarkShadow:     "#424242"   // The outer, darker portion of a control’s shadow.
    property color controlBlend:          "transparent"   // The surface of a control which might be transparent.

    property int controlBorderWidth: 1
    property int controlBorderWidthFocus: 2
    property int controlBorderRadius: 3

    property int pointSizeSmall: 9
    property int pointSizeNormal: 11
    property int pixelSizeNormal: 11
    property int pointSizeMedium: 13
    property int pointSizeLarge: 16
    property int pointSizeHuge: 18

    property int windowPadding: 20

    property QtObject base: QtObject {
        property color normal:     "#e6e6e6"
        property color border:     "#c0c6cc"
        property color alternate:  "#f0f0f0"
        property color alternate2: "#ffffff"
        property color alternate3: "#d0d6dc"
        property color edit:       "#ffffff"  // LineEdit background
        property color text:       "#fdfdfd"  // Eigengrau
        property color text2:      "#d0d0d0"  // secondary, less important
        property color text3:      "#8c8c8c"  // tenary, more less important
        property color textDisabled: "#8c8c8c"
        property color link:       "#007cfa"
        property color progressBarBackground: "#cccccc"
        property int inputSpacing: 16
        property int lineEditHeight: 32
        property int renderType:  Qt.platform.os === "linux" ? Text.QtRendering : Text.NativeRendering
        //property int renderType:  Text.QtRendering
    }
//    property QtObject lineEdit: QtObject {
//        property color alternate:  "#cecece"
//        property color background:        "#484848"
//    }
    property QtObject peerview: QtObject {
        property color alternate:  "#cecece"
        property color bar:        "#484848"
    }

    property QtObject preview: QtObject {
        property color background: "#484848"
        property color text: "#fcfcfc"
        property color text2: "#eeeeee"  // secondary, less important
    }

    property QtObject highlight: QtObject {
        property color info: "#3398ff"
        property color bar: "#ff8759"
        property color error: "#ff4533"
        property color success: "#81d624"
        property color pause: "#c1d624"
        property color normal:     "#007cfa"
        property color alternate:  "#3398ff"
        property color text:       "#ffffff"
    }
    property QtObject node: QtObject {
        property color view:       "#474747"
        property color normal:     "#fefefe"
        property color borderSelected: "#333333"
        property color borderDrag: "#ffdd55"
        property color text:       "#d5d7d0"
        property color text2:      "#a5a7a0"  // secondary, less important
        property color line:       "#888888"
        property color lineIndirect: "#5bd8ff"
        property real lineWidth: 2.0

        // used by peer name label above nodes
        property QtObject label0: QtObject {
            property color bg:     "#fafafa"
            property color fg:     "#d5d7d0"
        }

        // theme node drive styles
        property QtObject drive0: QtObject {
            property string name: "drive0"
            property color bg:     "#fefefe"
            property color fg:     "#d5d7d0"
        }

        // theme node sector styles
        property QtObject sector0: QtObject {
            property string name: "sector0"
            property color bg:     "#eeeeee"
            property color fg:     "#333333"
        }

        // theme node special styles (network)
        property QtObject special0: QtObject {
            property string name: "special0"
//            property int radius: 4
            property color bg:     "#fcfcfc"
            property color fg:     "#ffffff"
        }

        // theme node styles
        property QtObject style0: QtObject {
            property string name: "style0"
            property color bg:     "#595959"
            property color fg:     "#e2e2e2"
        }


        property QtObject style1: QtObject {
            property string name: "style1"
            property color bg:     "#434343"
            property color fg:     "#d7d9d3"
        }

        property QtObject style2: QtObject {
            property string name: "style2"
//            property bool bold: true
            property color bg:     "#bdcad9"
            property color fg:     "#333333"
        }

        property QtObject style3: QtObject {
            property string name: "style3"
            property color bg:     "#ffe6d5"
            property color fg:     "#333333"
        }

        property QtObject style4: QtObject {
            property string name: "style4"
            property color bg:     "#fff6d5"
            property color fg:     "#333333"
        }

        property QtObject style5: QtObject {
            property string name: "style5"
            property color bg:     "#f6ffd5"
            property color fg:     "#333333"
        }

        property QtObject style6: QtObject {
            property string name: "style6"
            property color bg:     "#e5ffd5"
            property color fg:     "#333333"
        }

        property QtObject style7: QtObject {
            property string name: "style7"
            property color bg:     "#e2e3db"
            property color fg:     "#333333"
        }

        property QtObject style8: QtObject {
            property string name: "style8"
            property color bg:     "#ffd5d5"
            property color fg:     "#333333"
        }

        property QtObject style9: QtObject {
            property string name: "style9"
            property color bg:     "#e3dbdb"
            property color fg:     "#333333"
        }

        property QtObject style10: QtObject {
            property string name: "style10"
            property color bg:     "#dbe3db"
            property color fg:     "#333333"
        }

        property QtObject style11: QtObject {
            property string name: "style11"
            property color bg:     "#d7f4ee"
            property color fg:     "#333333"
        }

        property QtObject style12: QtObject {
            property string name: "style12"
            property color bg:     "#bdd8fe"
            property color fg:     "#333333"
        }

        property QtObject style13: QtObject {
            property string name: "style13"
            property color bg:     "#dbe2e3"
            property color fg:     "#333333"
        }

        property QtObject style14: QtObject {
            property string name: "style14"
            property color bg:     "#d7e3f4"
            property color fg:     "#333333"
        }

        property QtObject style15: QtObject {
            property string name: "style15"
            property color bg:     "#e3d7f4"
            property color fg:     "#333333"
        }

        property QtObject style16: QtObject {
            property string name: "style16"
            property color bg:     "#f3efe0"
            property color fg:     "#333333"
        }
    }
}
