#!/bin/sh
# Requires a POSIX-ish shell.

#
# Originally From: http://hayne.net/MacDev/Bash/show_getinfo
#

# show_getinfo
# This script opens the Finder's "Get Info" window
# for the file or folder specified as a command-line argument.
# Cameron Hayne (macdev@hayne.net)  March 2003

# Chris Johnsen <chris_johnsen@pobox.com> August 2007, December 2009
#   Include Unicode path in AppleScript code via "utxt" block(s).
#   Handle case where cwd ends in newline.

utf8_to_AppleScript_utxt() {
    o="$(printf '\302\253')" # UTF-8 LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    c="$(printf '\302\273')" # UTF-8 RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    # AppleScript utxt:
    # <http://lists.apple.com/archives/applescript-implementors/2007/Mar/msg00024.html>
    # <<data utxtXXXX>> where
    #     << is actually U+00AB LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    #     >> is actually U+00BB RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    #   XXXX are the hex digits of UTF-16 code units
    # If a BOM is present, it specifies the byte order.
    #   The BOM code point will not be a part of the resulting string value.
    # If no BOM is present, the byte order interpreted as native.
    # The iconv invocation below *MUST*
    #      include a BOM
    #   or produce native byte ordering
    #   or include a BOM and produce native byte ordering.
    # In my testing, iconv to UTF-16 includes a BOM and uses native ordering.
    iconv -f UTF-8 -t UTF-16 |
    ( printf '("" as Unicode text'
        hexdump -ve "\" & ${o}data utxt\" 63/2 \"%04x\" \"$c\""
        printf ')\n' ) |
    sed -e 's/  *\('"$c"')\)$/\1/'
}

scriptname="${0##*/}"
if test "$#" -lt 1; then
    printf "usage: %s file-or-folder\n" "$scriptname"
    exit 1
fi

if ! test -e "$1"; then
    printf "%s: No such file or directory: %s\n" "$scriptname" "$1"
    exit 2
fi

if test "${1#/}" = "$1"; then set -- "$PWD/$1"; fi

set -- "$(printf %s "$1" | utf8_to_AppleScript_utxt)"

# 10.4 requires script text to be in the primary encoding (usually MacRoman)
# 10.5+ supports UTF-8, UTF-16 and the primary encoding
(iconv -f UTF-8 -t MACROMAN | osascript -) <<EOF
set macpath to POSIX file $1 as alias
tell app "Finder" 
	activate
	open information window of macpath
end tell
EOF
